library(scales)

csvDirectory = 'F:/Manuscripts/Chapter 1 Manuscript submission & data/4TU Data/Figure S6 oxygen statistics/Processed planar optode data/CSV/'
plotDirectory = 'F:/Manuscripts/Chapter 1 Manuscript submission & data/4TU Data/Figure S6 oxygen statistics/'

setwd(csvDirectory)
fileList = dir(pattern = '.csv')
n_files = length(fileList)

thresholdRate = 4.2
thresholdDepth = 0.15

#---------------------------------


setwd(plotDirectory)
tiff("Figure S8top.tif",width = 8, height = 6, units = 'in', res = 300)

timeShift = 4.5
plot(c(1), xlim = c(0,12), ylim = c(0.1,6),
     log = 'y', type = 'n', 
     xaxt = 'n', yaxt = 'n', xlab = '', ylab = '', bty = 'n')
rect(xleft = 0, xright = 12, 
     ytop = 1, ybottom = 0.8, 
     lty = 1, lwd = 2, border = alpha('blue',0.2))
rect(xleft = timeShift, xright = timeShift + 3, 
     ytop = 1, ybottom = 0.8, 
     lty = 0, border = alpha('blue',0.2),col = alpha('blue',0.5))
rect(xleft = timeShift, xright = timeShift + 3, 
     ytop = 6, ybottom = 1.04, 
     lty = 0, border = alpha('blue',0.2),col = alpha('blue',0.1))

text('High tide', x = timeShift + 1.5, y = 0.9, cex = 0.8)
text('Low tide', x = timeShift + 5.25, y = 0.9, cex = 0.8)
text('Low tide', x = timeShift - 2.25, y = 0.9, cex = 0.8)

color = c('green','yellow','blue')
for(i_file in c(3,1,2)){
  setwd(csvDirectory)
  
  file = fileList[i_file]
  d = read.csv(file)
  meanRate = rep(NA, times = length(unique(d$tideTime))-1)
  tideTime = rep(NA, times = length(unique(d$tideTime))-1)
  for(i in 1:(length(unique(d$tideTime))-1)){
    meanRate[i] = mean(d$rateWindow[d$tideTime == sort(unique(d$tideTime))[i]], na.rm = T)
    tideTime[i] = sort(unique(d$tideTime))[i]
  }
  
  setwd(plotDirectory)
  tideTimeShift = tideTime + timeShift
  tideTimeShift[tideTimeShift > 12] = tideTimeShift[tideTimeShift > 12] - 12
  meanRateShift = meanRate[order(tideTimeShift)]
  tideTimeShift = sort(tideTimeShift)
  
  lines(meanRateShift ~ tideTimeShift, lwd = 2, col = alpha(color[i_file],0.5))
  peakTideTime = tideTime[which.min(meanRate)] + timeShift
  peakRate = min(meanRate, na.rm = T)
  points(peakRate ~ peakTideTime, pch = 21, bg = alpha(color[i_file],0.5))
  
  meanRate = meanRate[tideTime > 0.3]
  tideTime = tideTime[tideTime > 0.3]
  duraction.hr = tideTime[meanRate > 4.1][1] + timeShift
  lines(x = c(duraction.hr,duraction.hr), y = c(4.1,1.3), 
        col = alpha(color[i_file],0.5), lty = 3, lwd = 2)
  
}

text('II', x= timeShift + 0.32, y = 1.25)
text('III', x= timeShift + 3.4, y = 3.1)
text('I', x= timeShift/2, y = 3.1)


rect(xleft = 0.5, xright = timeShift - 0.5, 
     ybottom = 3.7, ytop = 5.5, lwd = 1, lty = 1) 
lines(x = c(0,12), y = c(4.1,4.1), col = grey(0.5), lwd = 2, lty = 2)

dev.off()

